#-------------------------------------------------
#
# Project created by QtCreator 2017-09-21T12:25:02
#
#-------------------------------------------------
#
# Toolkit GUI, an application built for operating pinkRF's signal generators.
#
# Contact: https://www.pinkrf.com/contact/
# Copyright © 2018-2024 pinkRF B.V
# GNU General Public License version 3.
#
# This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
# This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
# You should have received a copy of the GNU General Public License along with this program. If not, see https://www.gnu.org/licenses/
#
# Author: Iordan Svechtarov



QT += core
QT += gui
QT += serialport
QT += serialbus
QT += network

greaterThan(QT_MAJOR_VERSION, 4): QT += widgets printsupport

TARGET = Toolkit_GUI
TEMPLATE = app

# The following define makes your compiler emit warnings if you use
# any feature of Qt which as been marked as deprecated (the exact warnings
# depend on your compiler). Please consult the documentation of the
# deprecated API in order to know how to port your code away from it.
DEFINES += QT_DEPRECATED_WARNINGS

#Uncomment to enable Rotary encoder functionality
#DEFINES += ROTARY_ENCODER_ENABLED
#DEFINES += I2C_TEMP_SENSOR
#DEFINES += ALT_MODBUS_IMPLEMENTATION
#DEFINES += ETHERCAT

#Uncomment to enable DEBUG features
#DEFINES += DEBUG

# Uncomment to select GUI type.
#
# Old standard GUI. Single-threaded.
# Remote command mode locks you out of using the GUI, but there are no limitions on what commands you can use.
# Has automatic port detection.
#DEFINES    += GUI_TOOLKIT

# Beta GUI. Improved version. Multi-threaded
# Blind remote command mode locks you out of using the GUI, but there are no limitions on what commands you can use.
# Live remote command mode, but only supports commands that have a one line response. Some commands are blacklisted.
# Does not have remote command mode over TCP, only USB.
# Has Modbus Support and PSU Menu.
# Does not have automatic port detection.
DEFINES    += GUI_1CHANNEL

# Derivative of the beta GUI.
# Supports Modbus, has an overview screen, has PSU menu.
# Has some ODC specific idiosyncrasies and workarounds.
#DEFINES += GUI_1CHANNEL_ODC

# Derivative of the beta GUI.
# 4 Channel GUI. Built to be used primarily through USB Remote Command Mode.
# Each channel has separate Frequency, Power, Phase / Autophase, RF ON/OFF, Errors, Clock Source indication
#DEFINES += GUI_4CHANNEL

# Derivative of the beta GUI.
# Proof of Concept GUI intended for smaller screens with button controls.
# Only basic features: Frequency, Power, RF ON/OFF, USB RCM.
#DEFINES += GUI_MINIMAL


# You can also make your code fail to compile if you use deprecated APIs.
# In order to do so, uncomment the following line.
# You can also select to disable deprecated APIs only up to a certain version of Qt.
#DEFINES += QT_DISABLE_DEPRECATED_BEFORE=0x060000    # disables all the APIs deprecated before Qt 6.0.0


#COMMON SOURCES AND HEADERS
SOURCES += \
        main.cpp \
        config_handler.cpp \
        miscellaneous.cpp \
        numpad.cpp \
        qcustomplot.cpp \
        rf_channel.cpp \
        rf_system.cpp \
        serial_v2.cpp \
        serial_v3.cpp \
        gpioclassv2.cpp \
        statuscheck.cpp

#	gui_1channel.cpp \
#	gui_1channel_odc.cpp \
#	gui_mainwindow.cpp \
#	gui_4channel.cpp \
#	gui_minimal.cpp \
#	rf_system_1channel.cpp \
#	rf_system_1channel_odc.cpp \
#	rf_system_4channel.cpp \
#	rf_system_minimal.cpp \
#	loggingclass.cpp \
#	modbusserver.cpp \
#	modbusserver_v2.cpp \
#	re_thread.cpp \
#	rcm_class.cpp \
#	rotaryswitch.cpp \


HEADERS += \
        config_handler.h \
        miscellaneous.h \
        numpad.h \
        qcustomplot.h \
        rf_channel.h \
        rf_system.h \
        serial_v2.h \
        serial_v3.h \
        gpioclassv2.h \
        statuscheck.h

#	gui_1channel.h \
#	gui_1channel_odc.h \
#	gui_mainwindow.h \
#	gui_4channel.h \
#	gui_minimal.h \
#	rf_system_1channel.h \
#	rf_system_1channel_odc.h \
#	rf_system_4channel.h \
#	rf_system_minimal.h \
#	loggingclass.h \
#	modbusserver.h \
#	modbusserver_v2.h \
#	re_thread.h \
#	rcm_class.h \
#	rotaryswitch.h \
#	thread.h \
#	try.h

#FORMS += \
#	mainwindow.ui \
#	gui_1channel.ui \
#	gui_1channel_odc.ui \
#	gui_4channel.ui \
#	gui_minimal.ui

contains(DEFINES, GUI_TOOLKIT){
        SOURCES += gui_mainwindow.cpp
        HEADERS += gui_mainwindow.h
        FORMS += mainwindow.ui

        SOURCES -= rf_channel.cpp \
                   rf_system.cpp \
                   serial_v3.cpp

        HEADERS -= rf_channel.h \
                   rf_system.h \
                   serial_v3.h
}

contains(DEFINES, GUI_1CHANNEL){
        SOURCES += \
                gui_1channel.cpp \
                loggingclass.cpp \
                modbusserver.cpp \
                rf_system_1channel.cpp \
                rcm_class.cpp

        HEADERS += \
                gui_1channel.h \
                loggingclass.h \
                modbusserver.h \
                rf_system_1channel.h \
                rcm_class.h

        FORMS += gui_1channel.ui
}

contains(DEFINES, GUI_1CHANNEL_ODC){
        SOURCES += \
                gui_1channel_odc.cpp \
                loggingclass.cpp \
                modbusserver.cpp \
                qcustomplot.cpp \
                rf_system_1channel_odc.cpp \
                rcm_class.cpp

        HEADERS += \
                gui_1channel_odc.h \
                loggingclass.h \
                modbusserver.h \
                qcustomplot.h \
                rf_system_1channel_odc.h \
                rcm_class.h

        FORMS += gui_1channel_odc.ui
}

contains(DEFINES, GUI_4CHANNEL){
        SOURCES += \
                gui_4channel.cpp \
                rf_system_4channel.cpp \
                rcm_class.cpp \
                rotaryswitch.cpp

        HEADERS += \
                gui_4channel.h \
                rf_system_4channel.h \
                rcm_class.h \
                rotaryswitch.h

        FORMS += gui_4channel.ui
}

contains(DEFINES, GUI_MINIMAL){
        SOURCES += \
                gui_minimal.cpp \
                rf_system_minimal.cpp \
                rcm_class.cpp

        HEADERS += \
                gui_minimal.h \
                rf_system_minimal.h \
                rcm_class.h

        FORMS += gui_minimal.ui

        SOURCES -= qcustomplot.cpp \
                   gpioclassv2.cpp

        HEADERS -= qcustomplot.h \
                   gpioclassv2.h
}




contains(DEFINES, ROTARY_ENCODER_ENABLED){
        SOURCES += re_thread.cpp
        HEADERS += re_thread.h
}

contains(DEFINES, ALT_MODBUS_IMPLEMENTATION){
        SOURCES -= modbusserver.cpp
        SOURCES += modbusserver_v2.cpp
        HEADERS -= modbusserver.h
        HEADERS += modbusserver_v2.h
}

contains(DEFINES, ETHERCAT) {
	SOURCES += ethercat/EasyCAT.cpp ethercat/slave.cpp ethercat/variable.cpp ethercat/variables.cpp
        HEADERS += ethercat/EasyCAT.h ethercat/slave.h ethercat/variable.h ethercat/config/rfgenerator.h ethercat/variables.h
#        HEADERS += ethercat/EasyCAT.h ethercat/slave.h ethercat/variable.h ethercat/config/rfgenerator.h ethercat/config/4channel_EtherCAT_map.h ethercat/variables.h
	SOURCES += ethercat/signalsslots.cpp ethercat/module.cpp
	HEADERS += ethercat/signalsslots.h ethercat/module.h
        HEADERS += thread.h \
                   try.h
	LIBS += -lbcm2835
}



RESOURCES += \
    resources.qrc

DISTFILES +=
